package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.Color;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.modele.objets.Objet;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un Objet
 */
public class SaisieObjet extends Saisie {

	/**
	 * Identifiant de l'objet (uniquement renseign en cas de modification d'attribut)  
	 */
	protected long idObjet = -1;	
	
	/**
	 * Libell pour le libell de l'objet 
	 */
	protected JLabel libelleObjet;	

	/**
	 * Texte du libell de l'objet 
	 */
	protected JTextField texteLibelleObjet;	
	
	/**
	 * Libell pour les donnes de l'objet 
	 */
	protected JLabel libelleObjetDonnees;
	
	/**
	 * Texte Objet
	 */
	protected JTextArea texteObjet;
	
	/**
	 * Ascenseur de l'Objet
	 */
	protected JScrollPane scrollObjet;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 */
	public SaisieObjet(FenetrePrincipale fenetre, int typeEcran) {

		this(fenetre, typeEcran, null);
		
	}

	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 * @param objet Objet permettant de pr-remplir les champs
	 */
	public SaisieObjet(FenetrePrincipale fenetre, int typeEcran, Objet objet) {

		super(fenetre,typeEcran);

		if(typeEcran == EcranUtil.TYPE_ECRAN_CREATION_OBJETS) {
			libelleObjet = new JLabel("Entrez un libell pour l'objet :");
			libelleObjetDonnees = new JLabel("Entrez l'objet sous forme hxadcimale :");
			texteLibelleObjet = new JTextField();
			texteObjet = new JTextArea();
		} else if(typeEcran == EcranUtil.TYPE_ECRAN_MODIFICATION_OBJETS) {
			libelleObjet = new JLabel("Libell de l'objet :");
			libelleObjetDonnees = new JLabel("Modifier la valeur de l'objet (sous forme hxadcimale) :");
			if(objet != null) {
				idObjet = objet.getIdObjet();
				if(objet.getLibelle() != null)
					texteLibelleObjet = new JTextField(objet.getLibelle());
				if(objet.getValeur() != null)
					texteObjet = new JTextArea(objet.getValeur());				
			}
			texteLibelleObjet.setEditable(false);
		}
		
		texteObjet.setLineWrap(true);
		texteObjet.setWrapStyleWord(true);	
		scrollObjet = new JScrollPane(texteObjet,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollObjet.setBackground(Color.white);
    	
	}	

	/**
     * Accesseur
     * @return Identifiant de l'objet
     */
	public long getIdObjet() {
		return idObjet;
	}	
	
	/**
     * Renvoie les donnes de l'objet
     * @return Donnes de l'objet
     */
	public String getObjet() {
		return texteObjet.getText();
	}

	/**
     * Renvoie le libell de l'objet
     * @return Libell de l'objet
     */
	public String getLibelleObjet() {
		return texteLibelleObjet.getText();
	}	
	
	/**
	 * Affiche les champs d'entre
	 * @param fenetre La fentre qui doit contenir l'cran d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleObjet, EcranUtil.styleLibelleSaisieObjet, 0, 0, 1, 1);
	        g.ajoute(texteLibelleObjet, EcranUtil.styleChampTexteLibelleObjet, 0, 1, 1, 1);
	        // Ligne 1
	        g.ajoute(libelleObjetDonnees, EcranUtil.styleLibelleSaisieObjet, 1, 0, 1, 1);
	        g.ajoute(scrollObjet, EcranUtil.styleScrollSaisieObjet, 1, 1, 1, 1);
	        // Ligne 2
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 2, 0, 1, 2);
	        // Ligne 3
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 3, 0, 1, 2);
	        
    	}
    }
}
